/*
 * This file only contains the main function of the whole project which display logo and move to freq and amp selct
 * screen for channel 1
 *
 * */
#include <math.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include "inc/hw_memmap.h"
#include "inc/hw_gpio.h"
#include "inc/hw_nvic.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/flash.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/uart.h"
#include "driverlib/udma.h"
#include "driverlib/rom.h"
#include "grlib/grlib.h"
#include "grlib/widget.h"
#include "grlib/canvas.h"
#include "grlib/checkbox.h"
#include "grlib/container.h"
#include "grlib/pushbutton.h"
#include "grlib/radiobutton.h"
#include "grlib/slider.h"

#include "lcd_tools/Kentec320x240x16_ssd2119_spi.h"
#include "lcd_tools/touch.h"


#include "InitializeFunctions.h"

extern void homeScreen(void);
extern void sendUARTCh1Data(void);
extern void sendUARTCh2Data(void);

/*
 *
 * a => homeScreen
 * b => FASel1
 * c => FASel2
 * d => displayWaveformCh1
 * e => displayWaveformCh2
 *
 * */
char screenChar = 'a';

extern void print_waveform_ch1();
extern void print_waveform_ch2();

extern const uint8_t g_DESElogoImage[];

bool sendFlagCh1 = false;
bool sendFlagCh2 = false;



float preFreq = 0,preFreqCh2 = 0;
float preAmp = 0,preAmpCh2 = 0;

char * input_str;
char * temp_str;
char doUARTOperation = 0;

extern void processString(char * temp);

int main(void)
{
    int count1 = 0,count2 = 0;

    system_init();
    // for the string rcv operation
    input_str = (char *)malloc(sizeof(char)*50);
    temp_str = input_str;

    FPUEnable(); //! Enables the floating-point unit.
    FPUStackingDisable();

    ui32SysClock = SysCtlClockGet(); // get the system clock

    Kentec320x240x16_SSD2119Init(ui32SysClock);
    GrContextInit(&sContext, &g_sKentec320x240x16_SSD2119);

    // touch screen intrrupt function enable
    TouchScreenInit(ui32SysClock);
    TouchScreenCallbackSet(WidgetPointerMessage);

    clr_scrn_total();

    GrImageDraw(&sContext, g_DESElogoImage, 0, 0); // display DESE logo
    GrFlush(&sContext);

    ms_delay(2000); //wait for 2sec
    clr_scrn_total();

    homeScreen();// go to the home screen

    while (1)
    {
        WidgetMessageQueueProcess();// wait for the click event to occur

        /*if(sendFlagCh1){
            sendUARTCh1Data();
        }

        if(sendFlagCh2){
            sendUARTCh2Data();
        }*/

        if(doUARTOperation){
            processString(input_str);
        }

       switch (screenChar)
        {
        case 'a': //homeScreen
            break;
        case 'b'://FASel 1
            break;
        case 'c'://FASel 2
            break;
        case 'd'://DW Ch 1
            /*if ((abs(freq - preFreq) != 0) || (abs(amp - preAmp) != 0)){
                preFreq = freq;
                preAmp = amp;*/
            count1++;
            if(count1 == 100000){
                count1 = 0;
                print_waveform_ch1();
            }
            break;
        case 'e'://DW Ch 2
            /*if ((abs(freqCh2 - preFreqCh2) != 0) || (abs(ampCh2 - preAmpCh2) != 0)){
             preFreqCh2 = freqCh2;
             preAmpCh2 = ampCh2;*/
            count2++;
            if (count2 == 100000)
            {
                count2 = 0;
                print_waveform_ch2();
            }
            break;
        }

    }

    return 0;
}



